/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.Reader;
import java.io.Serializable;
import java.util.Date;
import org.apache.lucene.document.DateField;
import org.apache.lucene.util.Parameter;

public final class Field
implements Serializable {
    private String name = "body";
    private Object fieldsData = null;
    private boolean storeTermVector = false;
    private boolean storeOffsetWithTermVector = false;
    private boolean storePositionWithTermVector = false;
    private boolean omitNorms = false;
    private boolean isStored = false;
    private boolean isIndexed = true;
    private boolean isTokenized = true;
    private boolean isBinary = false;
    private boolean isCompressed = false;
    private float boost = 1.0f;

    public void setBoost(float boost) {
        this.boost = boost;
    }

    public float getBoost() {
        return this.boost;
    }

    public static final Field Keyword(String name, String value) {
        return new Field(name, value, true, true, false);
    }

    public static final Field UnIndexed(String name, String value) {
        return new Field(name, value, true, false, false);
    }

    public static final Field Text(String name, String value) {
        return Field.Text(name, value, false);
    }

    public static final Field Keyword(String name, Date value) {
        return new Field(name, DateField.dateToString(value), true, true, false);
    }

    public static final Field Text(String name, String value, boolean storeTermVector) {
        return new Field(name, value, true, true, true, storeTermVector);
    }

    public static final Field UnStored(String name, String value) {
        return Field.UnStored(name, value, false);
    }

    public static final Field UnStored(String name, String value, boolean storeTermVector) {
        return new Field(name, value, false, true, true, storeTermVector);
    }

    public static final Field Text(String name, Reader value) {
        return Field.Text(name, value, false);
    }

    public static final Field Text(String name, Reader value, boolean storeTermVector) {
        Field f = new Field(name, value);
        f.storeTermVector = storeTermVector;
        return f;
    }

    public String name() {
        return this.name;
    }

    public String stringValue() {
        return this.fieldsData instanceof String ? (String)this.fieldsData : null;
    }

    public Reader readerValue() {
        return this.fieldsData instanceof Reader ? (Reader)this.fieldsData : null;
    }

    public byte[] binaryValue() {
        return this.fieldsData instanceof byte[] ? (byte[])this.fieldsData : null;
    }

    public Field(String name, String value, Store store, Index index) {
        this(name, value, store, index, TermVector.NO);
    }

    public Field(String name, String value, Store store, Index index, TermVector termVector) {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        if (value == null) {
            throw new NullPointerException("value cannot be null");
        }
        if (index == Index.NO && store == Store.NO) {
            throw new IllegalArgumentException("it doesn't make sense to have a field that is neither indexed nor stored");
        }
        if (index == Index.NO && termVector != TermVector.NO) {
            throw new IllegalArgumentException("cannot store term vector information for a field that is not indexed");
        }
        this.name = name.intern();
        this.fieldsData = value;
        if (store == Store.YES) {
            this.isStored = true;
            this.isCompressed = false;
        } else if (store == Store.COMPRESS) {
            this.isStored = true;
            this.isCompressed = true;
        } else if (store == Store.NO) {
            this.isStored = false;
            this.isCompressed = false;
        } else {
            throw new IllegalArgumentException("unknown store parameter " + store);
        }
        if (index == Index.NO) {
            this.isIndexed = false;
            this.isTokenized = false;
        } else if (index == Index.TOKENIZED) {
            this.isIndexed = true;
            this.isTokenized = true;
        } else if (index == Index.UN_TOKENIZED) {
            this.isIndexed = true;
            this.isTokenized = false;
        } else if (index == Index.NO_NORMS) {
            this.isIndexed = true;
            this.isTokenized = false;
            this.omitNorms = true;
        } else {
            throw new IllegalArgumentException("unknown index parameter " + index);
        }
        this.isBinary = false;
        this.setStoreTermVector(termVector);
    }

    public Field(String name, Reader reader) {
        this(name, reader, TermVector.NO);
    }

    public Field(String name, Reader reader, TermVector termVector) {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        if (reader == null) {
            throw new NullPointerException("reader cannot be null");
        }
        this.name = name.intern();
        this.fieldsData = reader;
        this.isStored = false;
        this.isCompressed = false;
        this.isIndexed = true;
        this.isTokenized = true;
        this.isBinary = false;
        this.setStoreTermVector(termVector);
    }

    public Field(String name, String string, boolean store, boolean index, boolean token) {
        this(name, string, store, index, token, false);
    }

    public Field(String name, byte[] value, Store store) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        this.name = name.intern();
        this.fieldsData = value;
        if (store == Store.YES) {
            this.isStored = true;
            this.isCompressed = false;
        } else if (store == Store.COMPRESS) {
            this.isStored = true;
            this.isCompressed = true;
        } else {
            if (store == Store.NO) {
                throw new IllegalArgumentException("binary values can't be unstored");
            }
            throw new IllegalArgumentException("unknown store parameter " + store);
        }
        this.isIndexed = false;
        this.isTokenized = false;
        this.isBinary = true;
        this.setStoreTermVector(TermVector.NO);
    }

    public Field(String name, String string, boolean store, boolean index, boolean token, boolean storeTermVector) {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        if (string == null) {
            throw new NullPointerException("value cannot be null");
        }
        if (!index && storeTermVector) {
            throw new IllegalArgumentException("cannot store a term vector for fields that are not indexed");
        }
        this.name = name.intern();
        this.fieldsData = string;
        this.isStored = store;
        this.isIndexed = index;
        this.isTokenized = token;
        this.storeTermVector = storeTermVector;
    }

    private void setStoreTermVector(TermVector termVector) {
        if (termVector == TermVector.NO) {
            this.storeTermVector = false;
            this.storePositionWithTermVector = false;
            this.storeOffsetWithTermVector = false;
        } else if (termVector == TermVector.YES) {
            this.storeTermVector = true;
            this.storePositionWithTermVector = false;
            this.storeOffsetWithTermVector = false;
        } else if (termVector == TermVector.WITH_POSITIONS) {
            this.storeTermVector = true;
            this.storePositionWithTermVector = true;
            this.storeOffsetWithTermVector = false;
        } else if (termVector == TermVector.WITH_OFFSETS) {
            this.storeTermVector = true;
            this.storePositionWithTermVector = false;
            this.storeOffsetWithTermVector = true;
        } else if (termVector == TermVector.WITH_POSITIONS_OFFSETS) {
            this.storeTermVector = true;
            this.storePositionWithTermVector = true;
            this.storeOffsetWithTermVector = true;
        } else {
            throw new IllegalArgumentException("unknown termVector parameter " + termVector);
        }
    }

    public final boolean isStored() {
        return this.isStored;
    }

    public final boolean isIndexed() {
        return this.isIndexed;
    }

    public final boolean isTokenized() {
        return this.isTokenized;
    }

    public final boolean isCompressed() {
        return this.isCompressed;
    }

    public final boolean isTermVectorStored() {
        return this.storeTermVector;
    }

    public boolean isStoreOffsetWithTermVector() {
        return this.storeOffsetWithTermVector;
    }

    public boolean isStorePositionWithTermVector() {
        return this.storePositionWithTermVector;
    }

    public final boolean isBinary() {
        return this.isBinary;
    }

    public boolean getOmitNorms() {
        return this.omitNorms;
    }

    public void setOmitNorms(boolean omitNorms) {
        this.omitNorms = omitNorms;
    }

    public final String toString() {
        StringBuffer result = new StringBuffer();
        if (this.isStored) {
            result.append("stored");
            if (this.isCompressed) {
                result.append("/compressed");
            } else {
                result.append("/uncompressed");
            }
        }
        if (this.isIndexed) {
            if (result.length() > 0) {
                result.append(",");
            }
            result.append("indexed");
        }
        if (this.isTokenized) {
            if (result.length() > 0) {
                result.append(",");
            }
            result.append("tokenized");
        }
        if (this.storeTermVector) {
            if (result.length() > 0) {
                result.append(",");
            }
            result.append("termVector");
        }
        if (this.storeOffsetWithTermVector) {
            if (result.length() > 0) {
                result.append(",");
            }
            result.append("termVectorOffsets");
        }
        if (this.storePositionWithTermVector) {
            if (result.length() > 0) {
                result.append(",");
            }
            result.append("termVectorPosition");
        }
        if (this.isBinary) {
            if (result.length() > 0) {
                result.append(",");
            }
            result.append("binary");
        }
        if (this.omitNorms) {
            result.append(",omitNorms");
        }
        result.append('<');
        result.append(this.name);
        result.append(':');
        if (this.fieldsData != null) {
            result.append(this.fieldsData);
        }
        result.append('>');
        return result.toString();
    }

    public static final class TermVector
    extends Parameter
    implements Serializable {
        public static final TermVector NO = new TermVector("NO");
        public static final TermVector YES = new TermVector("YES");
        public static final TermVector WITH_POSITIONS = new TermVector("WITH_POSITIONS");
        public static final TermVector WITH_OFFSETS = new TermVector("WITH_OFFSETS");
        public static final TermVector WITH_POSITIONS_OFFSETS = new TermVector("WITH_POSITIONS_OFFSETS");

        private TermVector(String name) {
            super(name);
        }
    }

    public static final class Index
    extends Parameter
    implements Serializable {
        public static final Index NO = new Index("NO");
        public static final Index TOKENIZED = new Index("TOKENIZED");
        public static final Index UN_TOKENIZED = new Index("UN_TOKENIZED");
        public static final Index NO_NORMS = new Index("NO_NORMS");

        private Index(String name) {
            super(name);
        }
    }

    public static final class Store
    extends Parameter
    implements Serializable {
        public static final Store COMPRESS = new Store("COMPRESS");
        public static final Store YES = new Store("YES");
        public static final Store NO = new Store("NO");

        private Store(String name) {
            super(name);
        }
    }
}

