/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.web.search.analysis;

import java.io.IOException;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public class ChineseFilter
extends TokenFilter {
    private Hashtable _stopTable;
    static /* synthetic */ Class class$0;

    public ChineseFilter(TokenStream in) {
        super(in);
        this.input = in;
        if (this._stopTable == null) {
            this.loadStopWords();
        }
    }

    public final Token next() throws IOException {
        Token token = this.input.next();
        while (token != null) {
            String text = token.termText();
            if (this._stopTable.get(text) == null) {
                switch (Character.getType(text.charAt(0))) {
                    case 1: 
                    case 2: 
                    case 9: 
                    case 10: {
                        if (text.length() <= 1) break;
                        return token;
                    }
                    case 5: {
                        return token;
                    }
                }
            }
            token = this.input.next();
        }
        return null;
    }

    private void loadStopWords() {
        String[] words = null;
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.epf.web.search.analysis.ChineseFilter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ResourceBundle bundle = ResourceBundle.getBundle(String.valueOf(clazz.getPackage().getName()) + ".StopWords");
            String property = bundle.getString("Search.stopWords");
            words = ChineseFilter.split(property, " ,", -1);
        }
        catch (Exception e) {
            words = StopAnalyzer.ENGLISH_STOP_WORDS;
        }
        this._stopTable = StopFilter.makeStopTable((String[])words);
    }

    public static String[] split(String str, String sep, int count) {
        if (str == null || count == 0 || count < -1) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(str, sep, count != -1);
        if (count == -1) {
            count = tokenizer.countTokens();
        }
        String[] result = new String[count];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String t = tokenizer.nextToken();
            if (i < count) {
                if (t.length() == 1 && sep.indexOf(t) != -1) continue;
                result[i++] = t;
                continue;
            }
            int n = count - 1;
            result[n] = String.valueOf(result[n]) + t;
        }
        return result;
    }
}

